% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_handling.r
\name{getfile}
\alias{getfile}
\title{Get a file name and path and store them in a list.}
\usage{
getfile(multi = FALSE, pattern = NULL, combine = TRUE)
}
\arguments{
\item{multi}{this is an indicator to allow the user to store the names of
multiple files found in the directory. This is useful in conjunction with
\code{\link[=poppr.all]{poppr.all()}}.}

\item{pattern}{a \code{\link[=regex]{regex()}} pattern for use while
\code{multi == TRUE}. This will grab all files matching this pattern.}

\item{combine}{\code{logical}. When this is set to \code{TRUE} (default), the
\code{$files} vector will have the path appended to them. When it is set to
\code{FALSE}, it will have the basename.}
}
\value{
\item{path}{a character string of the absolute path to the
chosen file or files}
\item{files}{a character vector containing the chosen file
name or names.}
}
\description{
getfile is a convenience function that serves as a wrapper for the functions
\code{\link[=file.choose]{file.choose()}}, \code{\link[=file.path]{file.path()}}, and \code{\link[=list.files]{list.files()}}.
If the user is working in a GUI environment, a window will pop up, allowing
the user to choose a specified file regardless of path.
}
\examples{
\dontrun{

x <- getfile()
poppr(x$files)

y <- getfile(multi=TRUE, pattern="^.+?dat$") 
#useful for reading in multiple FSTAT formatted files.

yfiles <- poppr.all(y$files)

}  
}
\author{
Zhian N. Kamvar
}
