% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IntersectionPOSet.R
\name{IntersectionPOSet}
\alias{IntersectionPOSet}
\title{Computing the intersection of a collection of posets.}
\usage{
IntersectionPOSet(poset1, poset2, ...)
}
\arguments{
\item{poset1}{An object of S4 class \code{POSet}.
Argument \code{poset1} must be created by using any function contained in the package aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...) .}

\item{poset2}{An object of S4 class \code{POSet}.
Argument \code{poset2} must be created by using any function contained in the package aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...) .}

\item{...}{Optional additional objects of S4 class \code{POSet}.
Optional arguments must be created by using any function contained in the package aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...) .}
}
\value{
The intersection poset, an object of S4 class \code{POSet}.
}
\description{
Computes the poset \eqn{(V, \leq_{\cap})=(V, \leq_1)\cap\cdots\cap(V,\leq_k)}.
}
\details{
Let \eqn{P_1 = (V, \leq_1),\cdots, P_k = (V, \leq_k)} be \eqn{k} posets on the same set \eqn{V}.
The intersection poset \eqn{P_{\cap}=P_1 \cap\cdots\cap P_k} is the poset \eqn{(V, \leq_{\cap})} where
\eqn{a\leq_{\cap} b} if and only if \eqn{a\leq_i b} for all \eqn{i=1\cdots k}.
}
\examples{
elems <- c("a", "b", "c", "d")

dom1 <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)

dom2 <- matrix(c(
  "a", "b",
  "b", "c",
  "b", "d"
), ncol = 2, byrow = TRUE)

pos1 <- POSet(elements = elems, dom = dom1)

pos2 <- POSet(elements = elems, dom = dom2)

pos_int <- IntersectionPOSet(pos1, pos2)


}
