% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LexMRP.R
\name{LexMRP}
\alias{LexMRP}
\title{MRP matrix computation over the set of lexicographic linear extensions.}
\usage{
LexMRP(nvar, deg)
}
\arguments{
\item{nvar}{positive integer specifying the number \eqn{k} of ordinal variables.}

\item{deg}{parameter specifying the number of degrees of each variable. If all \eqn{k} variables have the same number \eqn{m} of degrees, it can be:
\enumerate{
\item the positive integer \eqn{m}. In this case variable degree labels are supposed to be the integers \eqn{0<1<...<m}
and columns and rows of the computed MRP matrix are named accordingly to this;
\item a character vector of length \eqn{m} specifying the variable degree labels (in this case columns and rows of the computed MRP matrix are named accordingly to \code{deg}).
}

If the \eqn{k} variables have different number \eqn{(m_1,...,m_k)} of degrees, it can be:
\enumerate{
\item a length-\eqn{k} positive integers vector specifying the values of \eqn{m_1,...,m_k}. In this case variable degree labels for the \eqn{j}-th variable are
supposed to be the integers \eqn{0<1<...<m_j} and columns and rows of the computed MRP matrix are named accordingly to this;
\item a list of \eqn{k} character vectors. The \eqn{j}-th list element is a character vector of length \eqn{m_j} specifying the degree labels for the \eqn{j}-th variable
(in this case columns and rows of the computed MRP matrix are named accordingly to \code{deg}).
}}
}
\value{
the MRP matrix computed over the set of lexicographic linear extensions.
}
\description{
Considering the component-wise poset built stating from \eqn{k} ordinal variables,
computes MRP matrix by analyzing all poset lexicographic linear extensions.
}
\examples{

#variables with common number of degrees
# default labels for variable degrees
nvar <- 3
deg  <- 4
lMRP <- LexMRP(nvar=nvar, deg=deg)

#user supplied variable degree labels
nvar <- 3
deg  <- c("a","b","c","d")
lMRP <- LexMRP(nvar=nvar, deg=deg)


#variables with different numbers of degrees
# default labels for variable degrees
nvar <- 3
deg  <- c(4,2,3)
lMRP <- LexMRP(nvar=nvar, deg=deg)

#user supplied variable degree labels
nvar <- 3
deg  <- list(c("a","b","c","d"),c("0","1"),c("x","y","z"))
lMRP <- LexMRP(nvar=nvar, deg=deg)

}
