% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/array_format.R
\name{array_format}
\alias{array_format}
\title{Convert a vector to the array structure used in model}
\usage{
array_format(v)
}
\arguments{
\item{v}{A vector with names indicating the index location of each element in a new array.
See the details (particularly the example) for more about what this means.}
}
\value{
An array with elements of \code{v} placed in the appropriate location based on their
index names.
}
\description{
Use element names to place vector elements in
the appropriate location of an array.
}
\details{
Suppose you have an AxB matrix in your model, and you would like to
create an object that stores the posterior means in the same AxB matrix as found in
the model. For an AxB matrix, this is not too difficult to do "by-hand".
However, if there are also dimensions C, D, and E, missing values, etc. it becomes more difficult.
}
\note{
Up to 10 dimensions are currently supported. Please submit an
\href{https://github.com/bstaton1/postpack/issues}{issue}
should you find that you need more dimensions.
}
\examples{
# load example mcmc.list
data(cjs)

# find an array node from your model
match_params(cjs, "SIG")

# extract the posterior mean of it
SIG_mean = post_summ(cjs, "SIG")["mean",]

# note that it has element names
SIG_mean

# create a matrix with elements in the proper place
array_format(SIG_mean)

}
