% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/added_plotting_functions.R
\name{plot_interaction_surface}
\alias{plot_interaction_surface}
\title{Plot Interaction Assurance Surface/Heatmap/Lines (Multi-Effect Grid Friendly)}
\usage{
plot_interaction_surface(
  data,
  metric,
  effect1,
  effect2,
  n = NULL,
  line = FALSE,
  facet_by = NULL,
  agg_fun = mean,
  title = NULL,
  subtitle = NULL
)
}
\arguments{
\item{data}{Data frame (typically power_results$summary).}

\item{metric}{Name of the summary column to plot, e.g. "power_direction", "power_threshold".}

\item{effect1}{Name of effect grid column for x-axis.}

\item{effect2}{Name of effect grid column for y-axis or color/facets.}

\item{n}{Optional sample size to filter to (else averages/plots all n's).}

\item{line}{Logical; if TRUE, make a lineplot (effect1 on x, one line for each effect2).
If FALSE, make a heatmap or contour.}

\item{facet_by}{Optional grid column(s) to facet by.}

\item{agg_fun}{Aggregation function if multiple entries per cell (default = mean).}

\item{title, subtitle}{Optional plot labels.}
}
\value{
A ggplot object.
}
\description{
Visualizes a metric (e.g., assurance) as a function of two effect grid variables
for a fixed sample size or averaged over n. Allows line, heatmap, or contour modes.
}
