% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.meandiff.R
\name{ci.meandiff}
\alias{ci.meandiff}
\title{Power calculation for precision analysis (confidence interval) for a difference between two means}
\usage{
ci.meandiff(
  n1 = NULL,
  n.ratio = 1,
  halfwidth = NULL,
  sd = 1,
  alpha = 0.05,
  power = NULL,
  cond = FALSE,
  v = FALSE
)
}
\arguments{
\item{n1}{The sample size for group 1.}

\item{n.ratio}{The ratio n2/n1 between the sample sizes of two groups; defaults to 1 (equal group sizes).}

\item{halfwidth}{The desired halfwidth for the difference in means.}

\item{sd}{The estimated standard deviation; defaults to 1. Equal SDs in each group are assumed.}

\item{alpha}{The significance level (type 1 error rate); defaults to 0.05.}

\item{power}{The specified level of power.}

\item{cond}{Specify using unconditional or conditional probability. Defaults to FALSE.}

\item{v}{Either TRUE for verbose output or FALSE (default) to output computed argument only.}
}
\value{
A list of the arguments (including the computed one).
}
\description{
Calculates the "power" of a confidence interval for a difference between two means, that is, the probability
of achieving a 100(1 - alpha) percent confidence interval with halfwidth not greater
than a specified value. This function can solve for power, n1, n.ratio or alpha.
}
\details{
The unconditional probability is the probability of obtaining the desired precision
(i.e., that the observed halfwidth does not exceed the desired halfwidth)
regardless of whether or not the confidence interval includes the true parameter value.
The conditional probability is the probability of both obtaining the desired precision and having
the interval include the true parameter value.
}
\examples{
ci.meandiff(n1 = NULL, halfwidth = 0.25, power = 0.8)
ci.meandiff(n1 = 134, halfwidth = 0.25, cond = TRUE)
}
