% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ppiBRA2010}
\alias{ppiBRA2010}
\title{ppiBRA2010}
\format{A data frame with 10 columns and 101 rows:
\describe{
\item{\code{score}}{PPI score}
\item{\code{belowHalfWage}}{Below the half minimum wage line}
\item{\code{belowQtrWage}}{Below the quarter minimum wage line}
\item{\code{belowOneWage}}{Below the one minimum wage line}
\item{\code{belowTwoWage}}{Below the two minimum wage line}
\item{\code{extreme}}{USAID extreme poverty}
\item{\code{ppp125}}{Below $1.25 per day purchasing power parity (2005)}
\item{\code{ppp250}}{Below $2.50 per day purchasing power parity (2005)}
\item{\code{ppp375}}{Below $3.75 per day purchasing power parity (2005)}
\item{\code{ppp500}}{Below $5.00 per day purchasing power parity (2005)}
}}
\source{
\url{www.povertyindex.org}
}
\usage{
ppiBRA2010
}
\description{
Poverty Probability Index (PPI) lookup table for Brazil
}
\examples{
  # Access Brazil PPI table
  ppiBRA2010

  # Given a specific PPI score (from 0 - 100), get the row of poverty
  # probabilities from PPI table it corresponds to
  ppiScore <- 50
  ppiBRA2010[ppiBRA2010$score == ppiScore, ]

  # Use subset() function to get the row of poverty probabilities corresponding
  # to specific PPI score
  ppiScore <- 50
  subset(ppiBRA2010, score == ppiScore)

  # Given a specific PPI score (from 0 - 100), get a poverty probability
  # based on a specific poverty definition. In this example, the USAID
  # extreme poverty definition
  ppiScore <- 50
  ppiBRA2010[ppiBRA2010$score == ppiScore, "extreme"]

}
\keyword{datasets}
