% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intensity_overlay.R
\name{intensity_overlay}
\alias{intensity_overlay}
\title{Overlay intensity on plot frame}
\usage{
intensity_overlay(
  it,
  bottomRange,
  topRange,
  start,
  org_start = 0,
  tfrom0 = TRUE,
  range = NULL,
  color = "black",
  ind = NULL,
  drawSize = 1,
  axisLabel = "Intensity (dB)",
  min_max_only = TRUE,
  highlight = NULL,
  pitch_overlay = FALSE
)
}
\arguments{
\item{it}{IntensityTier object loaded using \link[rPraat:it.read]{rPraat::it.read} or other object
formatted in a similar way, i.e. a \code{list} object containing the elements
\code{t} (a vector of time values) and \code{i} (a vector of intensity values) of
identical length.}

\item{bottomRange}{Bottom y-axis range of the plot frame that intensity
is plotted on.}

\item{topRange}{Top y-axis range of the plot frame that intensity is
plotted on.}

\item{start}{Start time (in seconds) of desired plotted area.}

\item{org_start}{Start time (in seconds) of desired plotted area in the
original sound file.}

\item{tfrom0}{Logical; should time on the x-axis run from 0 or from the
original time? Default is \code{TRUE}.}

\item{range}{Vector of two integers giving the intensity range to be
used for producing intensity plots. Default is \code{NULL}, in which case the
range is simply the minimum and maximum levels in the curve.}

\item{color}{String giving the name of the color to be used for
plotting intensity. Default is \code{'black'}.}

\item{ind}{Integer indexing intensity relative to other plot components.
Default is \code{NULL}.}

\item{drawSize}{Number indicating the line width of the intensity contour.
Default is \code{1}. Controls the \code{lwd} argument of \link[graphics:lines]{graphics::lines}.}

\item{axisLabel}{String giving the name of the label to print along
the y-axis when plotting intensity. Default is \code{Intensity (dB)}.}

\item{min_max_only}{Logical; should only minimum and maximum values be given
on the y-axis? Default is \code{TRUE}. Can also be a logical vector if some but
not all plot components should have minimum and maximum values on the y-axis.
Ignored for TextGrid component.}

\item{highlight}{Named list giving parameters for differential
highlighting of the intensity contour based on the time domain. This list
should contain information about which parts of the plot to highlight, either
done with the \code{start} and \code{end} arguments which must be numbers or numeric
vectors, or using the \code{tier} and \code{label} arguments to highlight based on
information in a plotted TextGrid. Further contains the optional arguments
\code{color} (string or vector of strings, see \code{color}) and
\code{drawSize} (integer), and \code{background}
(a string specifying a background color).}

\item{pitch_overlay}{Logical; is pitch also overlaid on the same
plot frame? Default is \code{FALSE}.}
}
\value{
No return values, called internally by \link{praatpicture} and sibling
functions.
}
\description{
Function for overlaying intensity contour on another plot frame, viz. the
waveform or spectrogram. Instead of using this function directly, just use
\code{praatpicture('my_sound_file')} with \code{intensity_plotOnSpec} or
\code{pitch_plotOnWave} set to \code{TRUE}.
}
\examples{
# Don't use directly
datapath <- system.file('extdata', package='praatpicture')
soundFile <- paste0(datapath, '/1.wav')
praatpicture(soundFile, frames = 'spectrogram',
intensity_plotOnSpec = TRUE)
}
