/*
 * Decompiled with CFR 0.152.
 */
package auc2;

import auc.AUCCalculator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AUCWrapper {
    public static boolean DEBUG = false;
    private double mAucRoc = 0.0;
    private double mAucPrc = 0.0;
    private String mListFile;
    private String mFilePR;
    private String mListROC;
    private String mListSPR;
    private String mCrvFile;
    private boolean mParsed = false;
    private double[] mX;
    private double[] mY;
    private double[] aucs = new double[2];
    ArrayList<Float> tempMx = new ArrayList();
    ArrayList<Float> tempMY = new ArrayList();

    public static void main(String[] args) {
        if (DEBUG) {
            String testfname = String.valueOf(System.getProperty("user.dir")) + "/data/list.txt";
            AUCWrapper auc = new AUCWrapper();
            double[] aucs = auc.calcCurves(testfname);
            System.out.println(Arrays.toString(aucs));
            System.out.println(Arrays.toString(auc.getX()));
            System.out.println(Arrays.toString(auc.getY()));
            auc.delFiles();
        }
    }

    public double[] calcCurves(String fname) {
        this.mListFile = fname;
        this.mFilePR = String.valueOf(fname) + ".pr";
        this.mListROC = String.valueOf(fname) + ".roc";
        this.mListSPR = String.valueOf(fname) + ".spr";
        this.setCurveType("SPR");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        PrintStream old = System.out;
        System.setOut(ps);
        String[] args = new String[]{fname, "list"};
        AUCCalculator.main(args);
        System.out.flush();
        System.setOut(old);
        String[] lines = baos.toString().split("\n");
        this.parseLines(lines);
        ps.close();
        try {
            baos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mParsed = false;
        this.aucs[0] = this.mAucRoc;
        this.aucs[1] = this.mAucPrc;
        return this.aucs;
    }

    public void setCurveType(String crvtype) {
        if (crvtype == "PR") {
            this.mCrvFile = this.mFilePR;
        } else if (crvtype == "ROC") {
            this.mCrvFile = this.mListSPR;
        } else if (crvtype == "SPR") {
            this.mCrvFile = this.mListSPR;
        }
        this.mParsed = false;
    }

    public void readCurveFile() {
        this.tempMx.clear();
        this.tempMY.clear();
        FileReader freadr = null;
        try {
            freadr = new FileReader(this.mCrvFile);
        }
        catch (FileNotFoundException e) {
            System.err.println(e);
        }
        Scanner scanr = new Scanner(freadr);
        while (scanr.hasNextFloat()) {
            this.tempMx.add(Float.valueOf(scanr.nextFloat()));
            this.tempMY.add(Float.valueOf(scanr.nextFloat()));
        }
        scanr.close();
        try {
            freadr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mX = new double[this.tempMx.size()];
        this.mY = new double[this.tempMY.size()];
        int i = 0;
        while (i < this.tempMx.size()) {
            this.mX[i] = this.tempMx.get(i).doubleValue();
            this.mY[i] = this.tempMY.get(i).doubleValue();
            ++i;
        }
        this.mParsed = true;
    }

    public double[] getX() {
        if (!this.mParsed) {
            this.readCurveFile();
        }
        return this.mX;
    }

    public double[] getY() {
        if (!this.mParsed) {
            this.readCurveFile();
        }
        return this.mY;
    }

    public void clear() {
        this.mListFile = null;
        this.mFilePR = null;
        this.mListROC = null;
        this.mListSPR = null;
        this.mCrvFile = null;
        this.mX = null;
        this.mY = null;
    }

    public String delFiles() {
        if (this.mListFile == null) {
            return "not deleted";
        }
        File filePR = new File(this.mFilePR);
        File fileROC = new File(this.mListROC);
        File fileSPR = new File(this.mListSPR);
        boolean deleted = filePR.delete();
        if (deleted) {
            deleted = fileROC.delete();
        }
        if (deleted) {
            deleted = fileSPR.delete();
        }
        this.mListFile = null;
        this.mFilePR = null;
        this.mListROC = null;
        this.mListSPR = null;
        if (deleted) {
            return "deleted";
        }
        return "not deleted";
    }

    private void parseLines(String[] lines) {
        Pattern p1 = Pattern.compile("^Area Under the Curve for Precision - Recall.*");
        Pattern p2 = Pattern.compile("^Area Under the Curve for ROC.*");
        Matcher m1 = p1.matcher("");
        Matcher m2 = p2.matcher("");
        int i = 0;
        while (i < lines.length) {
            String[] aucflds;
            m1.reset(lines[i]);
            m2.reset(lines[i]);
            if (m1.matches()) {
                aucflds = lines[i].split(" is ");
                this.mAucPrc = Float.parseFloat(aucflds[1]);
            } else if (m2.matches()) {
                aucflds = lines[i].split(" is ");
                this.mAucRoc = Float.parseFloat(aucflds[1]);
            }
            ++i;
        }
    }
}

