% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpe_miscs.R
\name{coef.gpe}
\alias{coef.gpe}
\title{Coefficients for a General Prediction Ensemble (gpe)}
\usage{
\method{coef}{gpe}(object, penalty.par.val = "lambda.1se", ...)
}
\arguments{
\item{object}{object of class \code{\link{pre}}}

\item{penalty.par.val}{character. Penalty parameter criterion to be used for 
selecting final model: lambda giving minimum cv error (\code{"lambda.min"}) or 
lambda giving cv error that is within 1 standard error of minimum cv error 
("\code{lambda.1se}"). Alternatively, a numeric value may be specified, 
corresponding to one of the values of lambda in the sequence used by glmnet,
for which estimated cv error can be inspected by running 
\code{object$glmnet.fit} and \code{plot(object$glmnet.fit)}.}

\item{...}{additional arguments to be passed to \code{\link[glmnet]{coef.glmnet}}.}
}
\description{
coef function for \code{\link{gpe}}
}
\seealso{
\code{\link{coef.pre}}
}
