% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_infrequent_terms.R
\name{remove_infrequent_terms}
\alias{remove_infrequent_terms}
\title{Remove infrequently occurring terms from quanteda dfm.}
\usage{
remove_infrequent_terms(dfm_object, proportion_threshold = 0.01,
  indices = NULL, verbose = TRUE)
}
\arguments{
\item{dfm_object}{A quanteda dfm object.}

\item{proportion_threshold}{proportion of documents a term must be included in
to be included in the dfm.}

\item{indices}{Defaults to NULL. If not NULL, then it must be a numeric
vector specifying the column indices of terms the user would like to remove.
Useful for removing specific terms.}

\item{verbose}{Logical indicating whether more information should be printed
to the screen to let the user know about progress in preprocessing. Defaults
to TRUE.}
}
\value{
A reduced dfm.
}
\description{
Removes terms appearing in less than a specific proportion of
documents in a corpus from a dfm.
}
\examples{
\dontrun{
# load the package
library(preText)
# load in the data
data("UK_Manifestos")
# preprocess data
preprocessed_documents <- factorial_preprocessing(
    UK_Manifestos,
    use_ngrams = TRUE,
    infrequent_term_threshold = 0.02,
    verbose = TRUE)
updated_dfm <- remove_infrequent_terms(preprocessed_documents$dfm_list[[1]],
                                       proportion_threshold = 0.5,
                                       indices = NULL,
                                       verbose = TRUE)
}
}

