% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATE_surv.R
\name{drsurv}
\alias{drsurv}
\title{Doubly robust estimator of the average treatment effect with Cox model for survival data}
\usage{
drsurv(
  y,
  d,
  x.cate,
  x.ps,
  x.ipcw,
  trt,
  yf = NULL,
  tau0,
  surv.min = 0.025,
  ps.method = "glm",
  minPS = 0.01,
  maxPS = 0.99,
  ipcw.method = "breslow"
)
}
\arguments{
\item{y}{Observed survival or censoring time; vector of size \code{n}.}

\item{d}{The event indicator, normally \code{1 = event, 0 = censored}; vector of size \code{n}.}

\item{x.cate}{Matrix of \code{p.cate} baseline covariates specified in the outcome model; dimension \code{n} by \code{p.cate}.}

\item{x.ps}{Matrix of \code{p.ps} baseline covariates specified in the propensity score model; dimension \code{n} by \code{p.ps}.}

\item{x.ipcw}{Matrix of \code{p.ipw} baseline covariate specified in inverse probability of censoring weighting; dimension \code{n} by \code{p.ipw}.}

\item{trt}{Treatment received; vector of size \code{n} with treatment coded as 0/1.}

\item{yf}{Follow-up time, interpreted as the potential censoring time; vector of size \code{n} if the potential censoring time is known.}

\item{tau0}{The truncation time for defining restricted mean time lost.}

\item{surv.min}{Lower truncation limit for probability of being censored (positive and very close to 0).}

\item{ps.method}{A character value for the method to estimate the propensity score. Allowed values include one of:
\code{'glm'} for logistic regression with main effects only (default), or
\code{'lasso'} for a logistic regression with main effects and LASSO penalization on
two-way interactions (added to the model if interactions are not specified in \code{ps.model}).
Relevant only when \code{ps.model} has more than one variable.}

\item{minPS}{A numerical value (in [0, 1]) below which estimated propensity scores should be
truncated. Default is \code{0.01}.}

\item{maxPS}{A numerical value (in (0, 1]) above which estimated propensity scores should be
truncated. Must be strictly greater than \code{minPS}. Default is \code{0.99}.}

\item{ipcw.method}{The censoring model. Allowed values are: \code{'breslow'} (Cox regression with Breslow estimator of the baseline survivor function),
\code{'aft (exponential)'}, \code{'aft (weibull)'}, \code{'aft (lognormal)'} or \code{'aft (loglogistic)'}. Default is \code{'breslow'}.}
}
\value{
Return a list of 4 elements:
\itemize{
  \item{\code{rmst1}: } A numeric value of the estimated restricted mean survival time n the group \code{trt = 1}.
  \item{\code{rmst0}: } A numeric value of the estimated restricted mean survival time n the group \code{trt = 0}.
  \item{\code{log.rmtl.ratio}: } A numeric value of the estimated log rmtl ratio.
  \item{\code{log.hazard.ratio}: } A numeric value of the estimated log hazard ratio.
}
}
\description{
Doubly robust estimator of the average treatment effect between two treatments, which is the restricted mean time lost (RMTL) ratio
of treatment 1 over treatment 0 for survival outcomes.
}
