% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/etc_utils_dataframe.R, R/g_dataframe.R
\name{as.data.frame}
\alias{as.data.frame}
\alias{as.data.frame.sscurves}
\alias{as.data.frame.mscurves}
\alias{as.data.frame.smcurves}
\alias{as.data.frame.mmcurves}
\alias{as.data.frame.sspoints}
\alias{as.data.frame.mspoints}
\alias{as.data.frame.smpoints}
\alias{as.data.frame.mmpoints}
\alias{as.data.frame.aucroc}
\title{Convert a curves and points object to a data frame}
\usage{
\method{as.data.frame}{sscurves}(x, row.names = NULL, optional = FALSE,
  raw_curves = NULL, ...)

\method{as.data.frame}{mscurves}(x, row.names = NULL, optional = FALSE,
  raw_curves = NULL, ...)

\method{as.data.frame}{smcurves}(x, row.names = NULL, optional = FALSE,
  raw_curves = NULL, ...)

\method{as.data.frame}{mmcurves}(x, row.names = NULL, optional = FALSE,
  raw_curves = NULL, ...)

\method{as.data.frame}{sspoints}(x, row.names = NULL, optional = FALSE,
  raw_curves = NULL, ...)

\method{as.data.frame}{mspoints}(x, row.names = NULL, optional = FALSE,
  raw_curves = NULL, ...)

\method{as.data.frame}{smpoints}(x, row.names = NULL, optional = FALSE,
  raw_curves = NULL, ...)

\method{as.data.frame}{mmpoints}(x, row.names = NULL, optional = FALSE,
  raw_curves = NULL, ...)

\method{as.data.frame}{aucroc}(x, row.names = NULL, optional = FALSE, ...)
}
\arguments{
\item{x}{An \code{S3} object generated by \code{\link{evalmod}}.
  The \code{as.data.frame} function takes one of the following \code{S3} objects.

\enumerate{

  \item ROC and Precision-Recall curves (mode = "rocprc")

  \tabular{lll}{
    \strong{\code{S3} object}
    \tab \strong{# of models}
    \tab \strong{# of test datasets} \cr

    sscurves \tab single   \tab single   \cr
    mscurves \tab multiple \tab single   \cr
    smcurves \tab single   \tab multiple \cr
    mmcurves \tab multiple \tab multiple
  }

  \item Basic evaluation measures (mode = "basic")

  \tabular{lll}{
    \strong{\code{S3} object}
    \tab \strong{# of models}
    \tab \strong{# of test datasets} \cr

    sspoints \tab single   \tab single   \cr
    mspoints \tab multiple \tab single   \cr
    smpoints \tab single   \tab multiple \cr
    mmpoints \tab multiple \tab multiple
  }

  \item Fast AUC (ROC) calculation with the U statistic (mode = "aucroc")
  \tabular{lll}{
    \strong{\code{S3} object}
    \tab \strong{# of models}
    \tab \strong{# of test datasets} \cr

    aucroc \tab -   \tab -
  }
}

See the \strong{Value} section of \code{\link{evalmod}} for more details.}

\item{row.names}{Not used by this method.}

\item{optional}{Not used by this method.}

\item{raw_curves}{A Boolean value to specify whether raw curves are
shown instead of the average curve. It is effective only
when \code{raw_curves} is set to \code{TRUE}
of the \code{\link{evalmod}} function.}

\item{...}{Not used by this method.}
}
\value{
The \code{as.data.frame} function returns a data frame.
}
\description{
The \code{as.data.frame} function converts an \code{S3} object generated by
  \code{\link{evalmod}} to a data frame.
}
\examples{

\dontrun{
##################################################
### Single model & single test dataset
###

## Load a dataset with 10 positives and 10 negatives
data(P10N10)

## Generate an sscurve object that contains ROC and Precision-Recall curves
sscurves <- evalmod(scores = P10N10$scores, labels = P10N10$labels)

## Convert sscurves to a data frame
sscurves.df <- as.data.frame(sscurves)

## Show data frame
head(sscurves.df)

## Generate an sspoints object that contains basic evaluation measures
sspoints <- evalmod(mode = "basic", scores = P10N10$scores,
                    labels = P10N10$labels)
## Convert sspoints to a data frame
sspoints.df <- as.data.frame(sspoints)

## Show data frame
head(sspoints.df)


##################################################
### Multiple models & single test dataset
###

## Create sample datasets with 100 positives and 100 negatives
samps <- create_sim_samples(1, 100, 100, "all")
mdat <- mmdata(samps[["scores"]], samps[["labels"]],
               modnames = samps[["modnames"]])

## Generate an mscurve object that contains ROC and Precision-Recall curves
mscurves <- evalmod(mdat)

## Convert mscurves to a data frame
mscurves.df <- as.data.frame(mscurves)

## Show data frame
head(mscurves.df)

## Generate an mspoints object that contains basic evaluation measures
mspoints <- evalmod(mdat, mode = "basic")

## Convert mspoints to a data frame
mspoints.df <- as.data.frame(mspoints)

## Show data frame
head(mspoints.df)


##################################################
### Single model & multiple test datasets
###

## Create sample datasets with 100 positives and 100 negatives
samps <- create_sim_samples(10, 100, 100, "good_er")
mdat <- mmdata(samps[["scores"]], samps[["labels"]],
               modnames = samps[["modnames"]],
               dsids = samps[["dsids"]])

## Generate an smcurve object that contains ROC and Precision-Recall curves
smcurves <- evalmod(mdat, raw_curves = TRUE)

## Convert smcurves to a data frame
smcurves.df <- as.data.frame(smcurves)

## Show data frame
head(smcurves.df)

## Generate an smpoints object that contains basic evaluation measures
smpoints <- evalmod(mdat, mode = "basic")

## Convert smpoints to a data frame
smpoints.df <- as.data.frame(smpoints)

## Show data frame
head(smpoints.df)


##################################################
### Multiple models & multiple test datasets
###

## Create sample datasets with 100 positives and 100 negatives
samps <- create_sim_samples(10, 100, 100, "all")
mdat <- mmdata(samps[["scores"]], samps[["labels"]],
               modnames = samps[["modnames"]],
               dsids = samps[["dsids"]])

## Generate an mscurve object that contains ROC and Precision-Recall curves
mmcurves <- evalmod(mdat, raw_curves = TRUE)

## Convert mmcurves to a data frame
mmcurves.df <- as.data.frame(mmcurves)

## Show data frame
head(mmcurves.df)

## Generate an mmpoints object that contains basic evaluation measures
mmpoints <- evalmod(mdat, mode = "basic")

## Convert mmpoints to a data frame
mmpoints.df <- as.data.frame(mmpoints)

## Show data frame
head(mmpoints.df)


##################################################
### N-fold cross validation datasets
###

## Load test data
data(M2N50F5)

## Speficy nessesary columns to create mdat
cvdat <- mmdata(nfold_df = M2N50F5, score_cols = c(1, 2),
                lab_col = 3, fold_col = 4,
                modnames = c("m1", "m2"), dsids = 1:5)

## Generate an mmcurve object that contains ROC and Precision-Recall curves
cvcurves <- evalmod(cvdat)

## Convert mmcurves to a data frame
cvcurves.df <- as.data.frame(cvcurves)

## Show data frame
head(cvcurves.df)

## Generate an mmpoints object that contains basic evaluation measures
cvpoints <- evalmod(cvdat, mode = "basic")

## Convert mmpoints to a data frame
cvpoints.df <- as.data.frame(cvpoints)

## Show data frame
head(cvpoints.df)


##################################################
### AUC with the U statistic
###

## mode = "aucroc"
data(P10N10)
uauc1 <- evalmod(scores = P10N10$scores, labels = P10N10$labels,
                 mode="aucroc")

# as.data.frame 'aucroc'
as.data.frame(uauc1)

## mode = "aucroc"
samps <- create_sim_samples(10, 100, 100, "all")
mdat <- mmdata(samps[["scores"]], samps[["labels"]],
               modnames = samps[["modnames"]],
               dsids = samps[["dsids"]])
uauc2 <- evalmod(mdat, mode="aucroc")

# as.data.frame 'aucroc'
head(as.data.frame(uauc2))
}

}
\seealso{
\code{\link{evalmod}} for generating \code{S3} objects with
  performance evaluation measures.
}
