% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_aux.R
\name{assignCluster}
\alias{assignCluster}
\title{Make Cluster Assignments}
\usage{
assignCluster(X, centers)
}
\arguments{
\item{X}{matrix of observations}

\item{centers}{matrix of cluster centers}
}
\value{
A vector of cluster labels
}
\description{
Assigns observation to the nearest cluster center, using squared Euclidean distance.
}
\examples{
X <- matrix(rnorm(100*5), nrow=100, ncol=5)
centers <- matrix(runif(3*5), nrow=3, ncol=5)

cl <- assignCluster(X, centers)
table(cl)
}
\author{
Joshua Keller
}
