\name{llbt.worth}
\alias{llbt.worth}
\title{Function to calculate and print worth parameters from LLBT model results}
\description{
   Worth parameters are calculated from the results of an LLBT model fit, i.e., from
   \code{\link{llbtPC.fit}} or from a \code{gnm}-fit, respectively. For the latter, the
   function only works if the design matrix had been generated using \code{llbt.design}.
}
\usage{
llbt.worth(fitobj, outmat = "worth")
}
\arguments{
  \item{fitobj}{result of an LLBT model fit using either \code{\link{llbtPC.fit}} or
        \code{\link{gnm}} (having used a design matrix generated by \code{\link{llbt.design}}).
        }
  \item{outmat}{a matrix of estimated worth parameters (\code{outmat = "worth"}, the default) or
        LLBT model parameters (\code{outmat = "lambda"}).}
}
\details{If the LLBT model includes categorical subject covariates, the
  function provides estimates for all groups formed by the full
  crossclassification. Numerical subject covariates are not implemented (yet)(see Warning below).
}
\section{Warning}{
  If the LLBT model has been fitted including numerical subject covariates, they are
  ignored. However, estimates for the remaining predictors are calculated for convenience.
  Please note, that these cannot be interpreted as standard estimates but are intercepts
  of the regression model where the objects (or reparameterized objects) are explained
  by one or more numerical subject covariates.
}
\value{
  \code{llbt.worth} returns a matrix
  of worth or model parameters. If subject covariates have been specified, each column
  represents a group defined by the crossclassification of the subject covariates.

  In case of object-specific covariates (\code{gnm}-fit only) the rows are
  collapsed to the number of different combinations of object-specific covariate
  values and labelled accordingly. Additionally, there is an attribute \code{objtable}
  containing a summary of original objects (items) and their reparameterisation
  with object-specific covariates. This is a list or a matrix.

  The function \code{\link{plot}} gives a plot of the estimates.
}
\note{If a position effect has been fitted (for details see Dittrich, et.al., 1998),
the corresponding variable must have been named \code{pos}.
}
\author{Reinhold Hatzinger}
\seealso{\code{\link{llbtPC.fit}}, \code{\link{llbt.design}}, \code{\link{plot}}}
\examples{
    ## fit only first three objects with SEX effect
    data(cemspc)
    mod <- llbtPC.fit(cemspc, nitems=3, formel=~SEX, elim=~SEX, undec=TRUE)

    ## calculate and print worth parameters
    mw <- llbt.worth(mod)
    mw

    ## the same using llbt.design and gnm
    data(cemspc)
    des <- llbt.design(cemspc, nitems=3, cat.scovs="SEX")
    m2 <- gnm(y~o1+o2+o3+SEX:(o1+o2+o3)+g1, elim=SEX:mu, family=poisson, data=des)

    ## calculate and plot worth parameters
    w2 <- llbt.worth(m2)
    plot(w2)


    ## model with object specific covariates
    latin <- c(0,1,1,0,1,0)           # object-specific covariate
    LAT <- data.frame(LAT=latin)      # objcovs must be data frame with named columns

    onames <- c("LO","PA","MI","SG","BA","ST")

    des <- llbt.design(cemspc, nitems=6, objnames=onames, objcovs=LAT)
    m3 <- gnm(y~LAT+g1, eliminate=mu, family=poisson, data=des)
    w3 <- llbt.worth(m3)
    w3
    attr(w3, "objtable")
}
\keyword{models}
