% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cad_consortium_ptp.R
\name{calculate_cad2_2012_basic_ptp}
\alias{calculate_cad2_2012_basic_ptp}
\title{Calculate 2012 CAD2 Basic PTP for obstructive CAD}
\usage{
calculate_cad2_2012_basic_ptp(age, sex, chest_pain_type)
}
\arguments{
\item{age}{Input numeric value to indicate the age of the patient.}

\item{sex}{Input characters (female, male) to indicate the sex of the patient.
\itemize{
  \item female
  \item male
}}

\item{chest_pain_type}{Input characters (typical, atypical, nonanginal)
to indicate the chest pain characteristics of the patient.
\itemize{
  \item typical stands for the patient having typical chest pain.
  \item atypical stands for the patient having atypical chest pain.
  \item nonanginal stands for the patient having nonanginal or non-specific chest pain.
}}
}
\value{
A numeric value representing the patient's PTP for obstructive CAD
based on the 2012 CAD Consortium 2 (CAD2) basic model.
}
\description{
This function returns a patient's
pre-test probability (PTP) of obstructive
coronary artery disease based on the
2012 CAD Consortium 2 (CAD2) basic model.
}
\details{
The predictive model is based on
patients from 18 hospitals in Europe and the United States.
}
\examples{
# 40 year old female with typical chest pain
calculate_cad2_2012_basic_ptp(
    age = 40,
    sex = "female",
    chest_pain_type = "typical"
)
}
