% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confirm_ptp.R
\name{calculate_confirm_2015_ptp}
\alias{calculate_confirm_2015_ptp}
\title{Calculate 2015 CONFIRM Risk Score for obstructive CAD}
\usage{
calculate_confirm_2015_ptp(
  age,
  sex,
  have_typical_chest_pain,
  have_diabetes,
  have_hypertension,
  have_family_history,
  is_current_smoker,
  max_na_num_of_rf = 0,
  output = c("text", "percentage")
)
}
\arguments{
\item{age}{Input numeric value to indicate the age of the patient.}

\item{sex}{Input characters (female, male) to indicate the sex of the patient.
\itemize{
  \item female
  \item male
}}

\item{have_typical_chest_pain}{Input characters (no, yes) to indicate if the patient
has typical chest pain.
\itemize{
  \item no stands for not having typical chest pain.
  \item yes stands for having typical chest pain.
}}

\item{have_diabetes}{Input characters (no, yes) to indicate if the patient
only has diabetes.
\itemize{
  \item no stands for not having diabetes.
  \item yes stands for having diabetes.
}}

\item{have_hypertension}{Input characters (no, yes) to indicate if the patient
only has hypertension.
\itemize{
  \item no stands for not having hypertension.
  \item yes stands for having a hypertension.
}}

\item{have_family_history}{Input characters (no, yes) to indicate if the patient
only has a family history of CAD.
\itemize{
  \item no stands for not having a family history of CAD.
  \item yes stands for having a family history of CAD.
}}

\item{is_current_smoker}{Input characters (no, yes) to indicate if the patient
is a current smoker.
\itemize{
  \item no stands for patient is a current smoker.
  \item yes stands for patient is a not current smoker (past or non-smoker).
}}

\item{max_na_num_of_rf}{Input integer 0 to 5 to indicate the maximum number of
missing risk factors to tolerate before outputting an \code{NA}.
Default: 0}

\item{output}{Input text to indicate the how pre-test
probability results be expressed
Default: c("text", "percentage")
\itemize{
  \item text means the PTP will be expressed as a probability in text (0 to > 82.4).
  \item percentage means the PTP will be expressed as percentage text (0-100\%).
}}
}
\value{
A numeric value representing the patient's risk
score for obstructive CAD based on the 2015 CONFIRM Risk Score.
}
\description{
This function returns
a patient's risk score for obstructive
coronary artery disease based on the
2015 CONFIRM Risk Score.
}
\details{
The predictive model is based on CCTA images from 9093
patients from Phase I of the Coronary CT Angiography
EvaluatioN For Clinical Outcomes: An InteRnational Multicenter (CONFIRM) registry.
}
\examples{
# 30 years old male current smoker with typical chest pain
calculate_confirm_2015_ptp(
  age = 30,
  sex = "male",
  have_typical_chest_pain = "yes",
  have_diabetes = "no",
  have_hypertension = "no",
  have_family_history = "no",
  is_current_smoker = "yes",
  max_na_num_of_rf = 0,
  output = "percentage"
)
}
