\encoding{utf8}
\name{fdhs}
\alias{fdhs}
\alias{fdhs.boundary}
\alias{fdhs.clusters}
\docType{data}
\title{Fictitious data generated by a DHS simulation.}

\description{Data set generated by a Demographic and Health Survey (DHS) simulation on a fictitious country with a national prevalence of 10\%, 8000 having been surveyed, distributed in 401 clusters. this dataset is composed of 3 objects:\itemize{
\item \code{fdhs.clusters}: data frame (one line per cluster).
\item \code{fdhs.boundary}: object of class \code{\link[sp:SpatialPolygons-class]{SpatialPolygons}} corresponding to the borders of the fictitious country.
\item \code{fdhs}: object of class \code{\link[=prevR-class]{prevR}} returned by \code{\link{as.prevR}} using the two previous objects.
}}

\usage{fdhs}

\references{
Larmarange Joseph, Vallo Roselyne, Yaro Seydou, Msellati Philippe and Meda Nicolas (2011) "Methods for mapping regional trends of HIV prevalence from Demographic and Health Surveys (DHS)", \emph{Cybergeo : European Journal of Geography}, no 558, \url{http://cybergeo.revues.org/24606}, DOI: 10.4000/cybergeo.24606.

Larmarange Joseph (2007) \emph{Prévalences du VIH en Afrique : validité d'une mesure}, PhD thesis in demography, directed by Benoît Ferry, université Paris Descartes, \url{http://tel.archives-ouvertes.fr/tel-00320283}.

Larmarange Joseph, Vallo Roselyne, Yaro Seydou, Msellati Philippe Meda Nicolas and Ferry Benoît (2006), "Cartographier les données des enquêtes démographiques et de santé à partir des coordonnées des zones d'enquête", \emph{Chaire Quételet, 29 novembre au 1er décembre 2006}, Université Catholique de Louvain, Louvain-la-Neuve, Belgique, \url{http://www.uclouvain.be/13881.html}.
}

\examples{
\dontrun{
str(fdhs)
str(fdhs.clusters)
str(fdhs.boundary)
demo(prevR)
}
}
\keyword{datasets}