% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/currencies.R
\name{convert_currencies}
\alias{convert_currencies}
\title{Convert Currencies}
\usage{
convert_currencies(
  price_start,
  from,
  to,
  date = lubridate::today(),
  floor_unit = "day"
)
}
\arguments{
\item{price_start}{Numeric vector of prices in terms of `from` currenc(ies).}

\item{from}{Character vector of currenc(ies) of `price_start`.}

\item{to}{Character vector of currenc(ies) to convert `price_start` to.}

\item{date}{Date vector specifying date of exchange rate to use.}

\item{floor_unit}{Character string. Default is "day" meaning that `date` will
be converted based on daily conversion rates. Changing to "week" will
change conversions to be based on the start of the week of `date`.}
}
\value{
Numeric vector of `price_start` now in the `to` currenc(ies).
}
\description{
Vectorized approach to converting prices across potentially different dates
and between different currencies.
}
\examples{
\dontrun{
library(dplyr)

sales_transactions <- tibble(
  local_price = c(100, 80, 9200, 90),
  local_currency = c("USD", "EUR", "JPY", "USD"),
  final_currency = c("EUR", "USD", "USD", "JPY"),
  date_transaction = lubridate::ymd(c(20200601, 20200609, 20200614, 20200623))
)
# Some made-up sales transactions of different values and currencies
sales_transactions \%>\%
  mutate(
    converted_price = convert_currencies(
      price_start = local_price,
      from = local_currency,
      to = final_currency,
      date = date_transaction
    )
  )
}
}
