% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcd_cmdstan_model.R
\name{pcd_cmdstan_model}
\alias{pcd_cmdstan_model}
\title{Create a CmdStanModel with primarycensored Stan functions}
\usage{
pcd_cmdstan_model(include_paths = primarycensored::pcd_stan_path(), ...)
}
\arguments{
\item{include_paths}{Character vector of paths to include for Stan
compilation. Defaults to the result of \code{pcd_stan_path()}.}

\item{...}{Additional arguments passed to cmdstanr::cmdstan_model().}
}
\value{
A CmdStanModel object.
}
\description{
This function creates a CmdStanModel object using the Stan model and
functions from primarycensored and optionally includes additional
user-specified Stan files.
}
\details{
The underlying Stan model (\code{pcens_model.stan}) supports various features:
\itemize{
\item Multiple probability distributions for modeling delays
\item Primary and secondary censoring
\item Truncation
\item Optional use of reduce_sum for improved performance (via
within chain parallelism).
\item Flexible prior specifications
\item Optional computation of log-likelihood for model comparison
}
}
\examples{
\dontshow{if (requireNamespace("cmdstanr", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
if (!is.null(cmdstanr::cmdstan_version(error_on_NA = FALSE))) {
  model <- pcd_cmdstan_model(compile = FALSE)
  model
}
\dontshow{\}) # examplesIf}
}
\seealso{
Modelling wrappers for external fitting packages
\code{\link{fitdistdoublecens}()},
\code{\link{pcd_as_stan_data}()}
}
\concept{modelhelpers}
