% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/principal_curve.R
\name{principal_curve}
\alias{principal_curve}
\alias{lines.principal_curve}
\alias{plot.principal_curve}
\alias{points.principal_curve}
\alias{whiskers}
\title{Fit a Principal Curve}
\usage{
principal_curve(x, start = NULL, thresh = 0.001, maxit = 10,
  stretch = 2, smoother = c("smooth_spline", "lowess", "periodic_lowess"),
  trace = FALSE, plot_iterations = FALSE, ...)

\method{lines}{principal_curve}(x, ...)

\method{plot}{principal_curve}(x, ...)

\method{points}{principal_curve}(x, ...)

whiskers(x, s, ...)
}
\arguments{
\item{x}{a matrix of points in arbitrary dimension.}

\item{start}{either a previously fit principal curve, or else a matrix
of points that in row order define a starting curve. If missing or NULL,
then the first principal component is used.  If the smoother is
\code{"periodic_lowess"}, then a circle is used as the start.}

\item{thresh}{convergence threshold on shortest distances to the curve.}

\item{maxit}{maximum number of iterations.}

\item{stretch}{A stretch factor for the endpoints of the curve,
allowing the curve to grow to avoid bunching at the end.
Must be a numeric value between 0 and 2.}

\item{smoother}{choice of smoother. The default is
\code{"smooth_spline"}, and other choices are \code{"lowess"} and
\code{"periodic_lowess"}. The latter allows one to fit closed curves.
Beware, you may want to use \code{iter = 0} with \code{lowess()}.}

\item{trace}{If \code{TRUE}, the iteration information is printed}

\item{plot_iterations}{If \code{TRUE} the iterations are plotted.}

\item{...}{additional arguments to the smoothers}

\item{s}{a parametrized curve, represented by a polygon.}
}
\value{
An object of class \code{"principal_curve"} is returned. For this object
  the following generic methods a currently available: \code{plot, points, lines}.

  It has components:
    \item{s}{a matrix corresponding to \code{x}, giving their projections
      onto the curve.}
  \item{ord}{an index, such that \code{s[order, ]} is smooth.}
  \item{lambda}{for each point, its arc-length from the beginning of the
    curve. The curve is parametrized approximately by arc-length, and
    hence is \code{unit-speed}.}
  \item{dist}{the sum-of-squared distances from the points to their
    projections.}
  \item{converged}{A logical indicating whether the algorithm converged
    or not.}
  \item{num_iterations}{Number of iterations completed before returning.}
  \item{call}{the call that created this object; allows it to be
    \code{updated()}.}
}
\description{
Fits a principal curve which describes a smooth curve that passes through the \code{middle}
of the data \code{x} in an orthogonal sense.  This curve is a nonparametric generalization
of a linear principal component.  If a closed curve is fit (using \code{smoother = "periodic_lowess"})
then the starting curve defaults to a circle, and each fit is followed by a bias correction
suggested by Jeff Banfield.
}
\examples{
x <- runif(100,-1,1)
x <- cbind(x, x ^ 2 + rnorm(100, sd = 0.1))
fit1 <- principal_curve(x, plot_iterations = TRUE)
fit2 <- principal_curve(x, plot_iterations = TRUE, smoother = "lowess")
lines(fit1)
points(fit1)
plot(fit1)
whiskers(x, fit1$s)
}
\references{
Hastie, T. and Stuetzle, W.,
 \href{https://www.jstor.org/stable/2289936}{Principal Curves},
 JASA, Vol. 84, No. 406 (Jun., 1989), pp. 502-516,
 DOI: \href{https://doi.org/10.2307/2289936}{10.2307/2289936}
 (\href{https://web.stanford.edu/~hastie/Papers/principalcurves.pdf}{PDF}).
}
\seealso{
\code{\link{project_to_curve}}
}
\keyword{nonparametric}
\keyword{regression}
\keyword{smooth}
