% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotate.R
\name{clr_rotate}
\alias{clr_rotate}
\title{Rotate the colors around the hue wheel}
\source{
\url{https://en.wikipedia.org/wiki/HSL_and_HSV}
}
\usage{
clr_rotate(col, degrees = 0)
}
\arguments{
\item{col}{a color object or vector of any of the three kinds of R color
specifications, i.e., either a color name (as listed by colors()), a
hexadecimal string of the form "#rrggbb" or "#rrggbbaa" (see rgb), or a
positive integer i meaning palette()[i].}

\item{degrees}{Numeric between 0 and 360, denotion the about of degrees the
colors should be rotated. Now defaults to 0.}
}
\value{
a colors object of same length as col.
}
\description{
Rotate the colors around the hue wheel
}
\details{
The colors will be trainsformed to HSL color space (hue, saturation,
 lightness) where the hue of the color will be rotation.
}
\examples{
plot(clr_rotate(terrain.colors(10)))

plot(clr_rotate(terrain.colors(10), degrees = 90))

plot(clr_rotate(terrain.colors(10), degrees = 180))

plot(clr_rotate(rep("magenta", 11), degrees = seq(0, 360, length.out =  11)))
}
