% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srs.R
\name{srs}
\alias{srs}
\title{Stratified simple random sampling}
\usage{
srs(frame, stratid, nsamp, prn)
}
\arguments{
\item{frame}{Data frame (or data.table or tibble)
containing the elements to sample from.}

\item{stratid}{Variable in \code{frame} containing the strata.}

\item{nsamp}{Variable in \code{frame} containing the sample sizes.}

\item{prn}{Variable in \code{frame} containing the permanent random numbers.}
}
\value{
A copy of the input sampling frame together with the boolean variable
\code{sampled}, indicating sample inclusion.
}
\description{
Stratified simple random sampling (SRS) using permanent random numbers.
Can also be used for non-stratified SRS using a dummy stratum taking the
same value for each object.
}
\examples{
dfOut <- srs(
  frame = ExampleData,
  nsamp = ~nsample,
  stratid = ~stratum,
  prn = ~rands
)
}
\seealso{
\link{prnsamplr}, \link{samp}, \link{pps}, \link{transformprn},
\link{ExampleData}
}
