% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densityPlot.R
\name{getBootData}
\alias{getBootData}
\title{Get bootstrapped values}
\usage{
getBootData(semfit, what = "coef.boot", ...)
}
\arguments{
\item{semfit}{An object of class lavaan}

\item{what}{Character. What needs to be inspected/extracted?}

\item{...}{Further argument to be passed to lavaan::lavTech()}
}
\description{
Get bootstrapped values
}
\examples{
require(lavaan)
labels=list(X="cond",M="pmi",Y="reaction")
model=tripleEquation(labels=labels)
\donttest{
set.seed(1234)
semfit=sem(model,data=pmi,se="boot",bootstrap=100)
getBootData(semfit)
}
}
