% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renderer.R
\name{renderer_graphviz}
\alias{renderer_graphviz}
\title{Render as a plain graph

This renderer uses viz.js to render the process map using the DOT layout.}
\usage{
renderer_graphviz(
  svg_fit = TRUE,
  svg_contain = FALSE,
  svg_resize_fit = TRUE,
  zoom_controls = TRUE,
  zoom_initial = NULL
)
}
\arguments{
\item{svg_fit}{Whether to scale the process map to fully fit in its container. If set to `TRUE` the process map will be scaled to be fully visible and may appear very small.}

\item{svg_contain}{Whether to scale the process map to use all available space (contain) from its container. If set to `FALSE`, if `svg_fit` is set this takes precedence.}

\item{svg_resize_fit}{Whether to (re)-fit the process map to its container upon resize.}

\item{zoom_controls}{Whether to show zoom controls.}

\item{zoom_initial}{The initial zoom level to use.}
}
\value{
A rendering function to be used with \code{\link{animate_process}}
}
\description{
Render as a plain graph

This renderer uses viz.js to render the process map using the DOT layout.
}
\examples{
data(example_log)

# Animate the process with the default GraphViz DOT renderer
animate_process(example_log, renderer = renderer_graphviz())

}
\seealso{
animate_process
}
