% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/absent.R
\name{absent}
\alias{absent}
\title{Check if an activity is absent from a case}
\usage{
absent(activity, n = 1)
}
\arguments{
\item{activity}{The activity to check. Character vector of length one.}

\item{n}{n-1 is the allowed number of occurences of the activity. E.g. n = 1 means the activity should be absent, n = 2 means it is allowed to occur once.}
}
\description{
The `absent` rule can be used to check whether an activity is absent in a case or not. The `n` parameter can be configured to create a different level of _absence_.
When n = 1, an activity is not allowed to occur even a single time. The maximum number of times it is allowed to occur is `n-1`.
}
\examples{
library(bupaR)
library(eventdataR)

# Check for which patients the activity "MRI SCAN" is absent.
patients \%>\%
check_rule(absent("MRI SCAN"))

# Check for which patients the activity "Blood test"
# occurs maximum a single time, but not 2 times or more.
patients \%>\%
check_rule(absent("Blood test", n = 2))


}
\seealso{
Other Declarative Rules: \code{\link{and}},
  \code{\link{contains_between}},
  \code{\link{contains_exactly}}, \code{\link{contains}},
  \code{\link{ends}}, \code{\link{precedence}},
  \code{\link{responded_existence}},
  \code{\link{response}}, \code{\link{starts}},
  \code{\link{succession}}, \code{\link{xor}}
}
