% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_examples_df.R
\name{prepare_examples}
\alias{prepare_examples}
\title{Convert a dataset of type \code{\link{log}} into a preprocessed format.}
\usage{
prepare_examples(
  log,
  task = c("outcome", "next_activity", "next_time", "remaining_time", "remaining_trace",
    "remaining_trace_s2s"),
  features = NULL,
  ...
)
}
\arguments{
\item{log}{\code{\link{log}}: Object of class \code{\link{log}} or derivatives (\code{\link{grouped_log}}, \code{\link{eventlog}},
\code{\link{activitylog}}, etc.).}

\item{task}{\code{\link{character}}: a process monitoring task for which to prepare an event log.}

\item{features}{\code{\link{character}} (default \code{\link{NULL}}): additional features. Appends attributes (if present) numeric_features and/or categorical_features to a preprocessed event log.}

\item{...}{additional arguments.}
}
\value{
a preprocessed dataset of class \code{\link{ppred_examples_df}}.
}
\description{
an event log is converted into a tibble where each row contains a cumulative sequence of activities per case.
This sequence will eventually be feeded to the Transformer model's token embedding layer.
}
\examples{
library(processpredictR)
library(eventdataR)

prepare_examples(patients, "next_activity")


}
