% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterProteins.R
\name{onegroup_only}
\alias{onegroup_only}
\title{Proteins that are only expressed in a given group}
\usage{
onegroup_only(
  raw_df,
  abs_group,
  pres_group,
  set_na = 0.34,
  save = FALSE,
  file_path = NULL
)
}
\arguments{
\item{raw_df}{A \code{raw_df} object (output of \code{\link{create_df}})}

\item{abs_group}{Name of the group in which proteins are not expressed.}

\item{pres_group}{Name of the group in which proteins are expressed.}

\item{set_na}{The percentage of missing data allowed in \code{pres_group}.
Default is 0.34 (one third of the samples in the group).}

\item{save}{Logical. If \code{TRUE} (default), it saves the output in a text
file named "Group_\code{pres_group}_only.txt."}

\item{file_path}{A string containing the directory path to save the file.}
}
\value{
A list of majority protein IDs.
}
\description{
This function outputs a list of proteins that are only
expressed (present) in one user-specified group while not expressed
(completely absent) in another user-specified group.
}
\details{
Note: \code{onegroup_only} function assumes that column names in
the \code{raw_df} object provided as \code{df} follow "Group_UniqueSampleID"
notation. (Use \code{head(raw_df)} to check the structure of your
\code{raw_df} object.)
\itemize{\item Given a pair of groups, \code{onegroup_only}
function finds proteins that are only expressed in \code{pres_group} while
completely absent or not expressed in \code{abs_group}.
\item A text file containing majority protein IDs will be saved in a
temporary directory if \code{file_path} is not specified.}
}
\examples{
# Generate a raw_df object with default settings. No technical replicates.
raw_df <- create_df(
prot_groups = "https://raw.githubusercontent.com/caranathunge/promor_example_data/main/pg1.txt",
exp_design = "https://raw.githubusercontent.com/caranathunge/promor_example_data/main/ed1.txt"
)

## Find the proteins only expressed in group L, but absent in group H.
onegroup_only(raw_df, abs_group = "H",
pres_group = "L")

}
\author{
Chathurani Ranathunge
}
