\name{resample}
\alias{resample}
\title{Resample spectral data}
\usage{
  resample(X,wav,new.wav,interpol)
}
\arguments{
  \item{X}{numeric \code{data.frame}, \code{matrix} or
  \code{vector} to resample}

  \item{wav}{a numeric vector giving the original band
  positions}

  \item{new.wav}{a numeric vector giving the new band
  positions}

  \item{interpol}{interpolation method: 'linear' or
  'spline'}
}
\value{
  a \code{matrix} or \code{vector} with resampled values
}
\description{
  Resample a data \code{matrix}, \code{data.frame} or
  \code{vector} to new coordinates (e.g. band positions)
  using spline or linear interpolation. This function is a
  simple wrapper around \code{\link{approx}} and
  \code{\link{splinefun}} in \pkg{base}.
}
\examples{
data(NIRsoil)
wav <- as.numeric(colnames(NIRsoil$spc))
spc <- 1/10^NIRsoil$spc # conversion to reflectance
resampled <- resample(spc,wav,1100:2498) # increase spectral resolution by 2
dim(spc);dim(resampled)
}
\author{
  Antoine Stevens
}
\seealso{
  \code{\link{resample2}}
}

