% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plotwithprototypes}
\alias{plotwithprototypes}
\title{Plot dendrogram with prototype labels added}
\usage{
plotwithprototypes(hc, imerge = -seq(n), labels = NULL, bgcol = "white",
  font = 1, col = 1, cex = 1, ...)
}
\arguments{
\item{hc}{an object of class \code{protoclust} (as returned by the function
\code{protoclust})}

\item{imerge}{a vector of the nodes whose prototype labels should be added.
Interior nodes are numbered from 1 (lowest merge) to n - 1 (highest merge,
i.e. the root) and leaf-nodes are negative (so if element i is a prototype
for a singleton cluster, then -i is included in imerge).  Example:
\code{seq(1, n - 1)} means every interior node is labeled with a prototype.
For larger trees, showing only the prototypes at a given cut may be easier
(described more below). Default: \code{-seq(n)}, meaning all leaf labels and
no interior-node labels are shown.}

\item{labels}{an optional character vector of length n giving the labels of
the elements clustered.  If not provided, hc$labels is used (if not NULL) or
else labels are taken to be \code{seq(n)}.}

\item{bgcol}{background color for prototype labels}

\item{col,font}{color and font of prototype labels}

\item{cex}{size of prototype label}

\item{...}{additional arguments to be passed to \code{plot.hclust}, such as
\code{hang}}
}
\description{
Makes a plot of the dendrogram (using \code{plot.hclust}) and adds labels of
prototypes on the interior nodes of a dendrogram.
}
\details{
This function lets one put prototype labels on a dendrogram.  The argument
\code{imerge} controls which interior nodes and leaves are labeled.  A
convenient choice for the argument \code{imerge} is the \code{imerge}-output
of \code{\link{protocut}}.  This allows one to label a dendrogram with the
prototypes of a particular cut.  See examples below.  This function is
called when one writes \code{plot(hc)}, where \code{hc} is an object of
class \code{protoclust}.
}
\examples{
# generate some data:
set.seed(1)
n <- 100
p <- 2
x <- matrix(rnorm(n * p), n, p)
rownames(x) <- paste("A", 1:n, sep="")
d <- dist(x)

# perform minimax linkage clustering:
hc <- protoclust(d)

# cut the tree to yield a 10-cluster clustering:
k <- 10 # number of clusters
cut <- protocut(hc, k=k)
h <- hc$height[n - k]

# plot dendrogram (and show cut):
plotwithprototypes(hc, imerge=cut$imerge)
# or more simply: plot(hc, imerge=cut$imerge)
abline(h=h, lty=2)

# negative values of imerge specify which leaves to label
k2 <- 20 # more clusters... with two singletons
cut2 <- protocut(hc, k=k2)
h2 <- hc$height[n - k2]
plot(hc, hang=-1, imerge=cut2$imerge)
abline(h=h2, lty=2)
}
\author{
Jacob Bien and Rob Tibshirani
}
\references{
Bien, J., and Tibshirani, R. (2011), "Hierarchical Clustering
with Prototypes via Minimax Linkage," accepted for publication in \emph{The
Journal of the American Statistical Association}, DOI:
10.1198/jasa.2011.tm10183.
}
\seealso{
\code{\link{protoclust}}, \code{\link{protocut}}
}
\keyword{cluster}

