% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_uniprot_proteome.R
\name{fetch_uniprot_proteome}
\alias{fetch_uniprot_proteome}
\title{Fetch proteome data from UniProt}
\usage{
fetch_uniprot_proteome(organism_id, columns = c("id"), reviewed = TRUE)
}
\arguments{
\item{organism_id}{An NCBI taxonomy identifier of an organism (TaxId)}

\item{columns}{Metadata columns that should be imported from UniProt (all possible columns can be found here: https://www.uniprot.org/help/uniprotkb_column_names). Note: Not more than one or two columns should be selected otherwise the function will not be able to efficiently retrieve the information. If more information is needed, \code{fetch_uniprot()} can be used with the IDs retrieved by this function.}

\item{reviewed}{Logical. If true, only reviewed protein entries will be retrieved.}
}
\value{
A data frame that contains all protein metadata specified in \code{columns} for the organism provided.
}
\description{
Fetches proteome data from UniProt for the provided organism ID.
}
\examples{
\donttest{
fetch_uniprot_proteome(9606)
}
}
