% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pval_distribution.R
\name{plot_pval_distribution}
\alias{plot_pval_distribution}
\title{Plot histogram of p-value distribution}
\usage{
plot_pval_distribution(data, grouping, pval)
}
\arguments{
\item{data}{a data frame containing at least grouping identifiers (precursor, peptide or protein) and p-values derived from any
statistical test.}

\item{grouping}{the column in the data frame containing either precursor, peptide or protein identifiers.}

\item{pval}{the column in the data frame containing p-values.}
}
\value{
A histogram or boxplot that shows the intensity distribution over all samples or by sample.
}
\description{
Plots the distribution of p-values derived from any statistical test as a histogram.
}
\examples{
\dontrun{
plot_pval_distribution(
  data,
  grouping = eg_precursor_id,
  pval = pval
)
}
}
