% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_pdb_structure.R
\name{fetch_pdb_structure}
\alias{fetch_pdb_structure}
\title{Fetch PDB structure atom data from RCSB}
\usage{
fetch_pdb_structure(pdb_ids, return_data_frame = FALSE, show_progress = TRUE)
}
\arguments{
\item{pdb_ids}{a character vector of PDB identifiers.}

\item{return_data_frame}{a logical value that indicates if a data frame instead of a list is
returned. It is recommended to only use this if not many pdb structures are retrieved. Default
is FALSE.}

\item{show_progress}{a logical value that indicates if a progress bar will be shown.
Default is TRUE.}
}
\value{
A list that contains atom data for each PDB structures provided. If return_data_frame is
TRUE, a data frame with this information is returned instead. The data frame contains the
following columns:
\itemize{
\item label_id: Uniquely identifies every atom in the structure following the standardised
convention for mmCIF files. Example value: "5", "C12", "Ca3g28", "Fe3+17", "H*251", "boron2a",
"C a phe 83 a 0", "Zn Zn 301 A 0"
\item type_symbol: The code used to identify the atom species representing this atom type.
Normally this code is the element symbol. The code may be composed of any character except an
underscore with the additional proviso that digits designate an oxidation state and must be
followed by a + or - character. Example values: "C", "Cu2+", "H(SDS)", "dummy", "FeNi".
\item label_atom_id: Uniquely identifies every atom for the given residue following the
standardised convention for mmCIF files. Example values: "CA", "HB1", "CB", "N"
\item label_comp_id: A chemical identifier for the residue. For protein polymer entities,
this is the three- letter code for the amino acid. For nucleic acid polymer entities, this is
the one-letter code for the base. Example values: "ala", "val", "A", "C".
\item label_asym_id: Chain identifier following the standardised convention for mmCIF files.
Example values: "1", "A", "2B3".
\item entity_id: Records details about the molecular entities that are present in the
crystallographic structure. Usually all different types of molecular entities such as polymer
entities, non-polymer entities or water molecules are numbered once for each structure. Each
type of non-polymer entity has its own number. Thus, the highest number in this column
represents the number of different molecule types in the structure.
\item label_seq_id: Uniquely and sequentially identifies residues for each \code{label_asym_id}.
This is always a number and the sequence of numbers always progresses in increasing numerical order.
\item x: The x coordinate of the atom.
\item y: The y coordinate of the atom.
\item z: The z coordinate of the atom.
\item site_occupancy: The fraction of the atom type present at this site.
\item b_iso_or_equivalent: Contains the B-factor or isotopic atomic displacement factor for
each atom.
\item formal_charge: The net integer charge assigned to this atom. This is the formal charge
assignment normally found in chemical diagrams. It is currently only assigned in a small subset
of structures.
\item auth_seq_id: An alternative residue identifier (\code{label_seq_id}) provided by the
author of the structure in order to match the identification used in the publication that
describes the structure. This does not need to be numeric and is therefore of type character.
\item auth_comp_id: An alternative chemical identifier (\code{label_comp_id}) provided by the
author of the structure in order to match the identification used in the publication that
describes the structure.
\item auth_asym_id: An alternative chain identifier (\code{label_asym_id}) provided by the
author of the structure in order to match the identification used in the publication that
describes the structure.
\item pdb_model_number: The PDB model number.
\item pdb_id: The protein database identifier for the structure.
}
}
\description{
Fetches atom data for a PDB structure from RCSB. If you want to retrieve metadata about PDB
structures, use the function \code{fetch_pdb()}. The information retrieved is based on the
.cif file of the structure, which may vary from the .pdb file.
}
\examples{
\donttest{
pdb_structure <- fetch_pdb_structure(
  pdb_ids = c("6HG1", "1E9I", "6D3Q", "4JHW"),
  return_data_frame = TRUE
)

head(pdb_structure, n = 10)
}
}
