% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{get.lineage}
\alias{get.lineage}
\title{Calculate lineage of a node}
\usage{
get.lineage(adj.graph, node.id, forward = FALSE)
}
\arguments{
\item{adj.graph}{An adjacency graph to get the lineage from, or a ProvGraphInfo object.  The
object can be created by a call to create.graph.}

\item{node.id}{The string id for a node that the lineage is
being requested for}

\item{forward}{Logical that states whether the search is going forward
through the graph from the provided node, or backwards.}
}
\value{
get.lineage returns the forward or backward lineage of the specified node.  The lineage
  is represented as a vector of strings, with each string being the id of a node in the lineage.
  The first entry in the returned vector is the node.id passed in.  The remaining entries
  form a path either forward or backward through the adjacency graph.
}
\description{
get.lineage returns either the list of nodes that the provided node depends
on (backward lineage) or the list of nodes that depend on the provided node 
(forward lineage).
}
\details{
Most commonly, the node passed in is a data node representing either a variable,
a file, or a plot.  Forward lineage reports everything computed from that variable
or file.  Backward lineage reports everything that contributed to the variable's 
value, the contents of an output file or plot.
}
\examples{
adj.graph <- create.graph(system.file("testdata", "basic.json", package = "provGraphR"))
get.lineage (adj.graph, "d24")

}
\seealso{
\code{\link{create.graph}}
}
