% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/provenance.R
\name{dist}
\alias{dist}
\alias{dist.DZdata}
\alias{dist.HMdata}
\alias{dist.default}
\title{Calculate the dissimilarity matrix between two \code{DZdata} or
\code{HMdata} datasets}
\usage{
dist(x, ...)

\method{dist}{default}(x, ...)

\method{dist}{DZdata}(x, metric = NULL, ...)

\method{dist}{HMdata}(x, metric = NULL, ...)
}
\arguments{
\item{x}{an object of class \code{DZdata} or \code{HMdata}}

\item{...}{optional arguments to the generic dist function}

\item{metric}{(optional) either "KS", "SH", "aitchison" or "bray"}
}
\value{
a matrix of pairwise distances
}
\description{
Calculate the dissimilarity matrix between two datasets of class
\code{DZdata} or \code{HMdata} using the Kolmogorov-Smirnov,
Sircombe-Hazelton, Aitchison or Bray Curtis distance
}
\examples{
fname <- system.file("DZ.csv",package="provenance")
DZ <- read.DZdata(fname)
print(round(100*dist(DZ)))
}

