% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read.counts}
\alias{read.counts}
\title{Read a .csv file with point-counting data}
\usage{
read.counts(
  fname,
  method = "chisq",
  colmap = "rainbow",
  sep = ",",
  dec = ".",
  row.names = 1,
  header = TRUE,
  check.names = FALSE,
  ...
)
}
\arguments{
\item{fname}{a string with the path to the .csv file}

\item{method}{either "chisq" (for the chi-square distance) or
"bray" (for the Bray-Curtis distance)}

\item{colmap}{an optional string with the name of one of R's
built-in colour palettes (e.g., heat.colors, terrain.colors,
topo.colors, cm.colors), which are to be used for plotting the
data.}

\item{sep}{the field separator character.  Values on each line of
the file are separated by this character.}

\item{dec}{the character used in the file for decimal points.}

\item{row.names}{a vector of row names.  This can be a vector
giving the actual row names, or a single number giving the
column of the which contains the row names, or character string
the name of the table column containing the row names.}

\item{header}{a logical value indicating whether the file contains
the names of the variables as its first line.}

\item{check.names}{logical.  If \code{TRUE} then the names of the
variables in the frame are checked to ensure that they are
syntactically variable names.}

\item{...}{optional arguments to the built-in \code{read.table}
function}
}
\value{
an object of class \code{counts}, i.e. a list with the
    following items:

\code{x}: a data frame with the samples as rows and the categories
as columns

\code{colmap}: the colour map provided by the input argument

\code{name}: the name of the data object, extracted from the file path
}
\description{
Reads a data table containing point-counting data
(e.g. petrographic, heavy mineral, palaeontological or
palynological data)
}
\examples{
    fname <- system.file("HM.csv",package="provenance")
    Major <- read.counts(fname)
    #plot(PCA(HM))
}
