% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotatePeptides.R
\name{annotatePeptides}
\alias{annotatePeptides}
\title{Annotate peptides with protein ids}
\usage{
annotatePeptides(pepinfo, fasta, prefix = "(([RK])|(^)|(^M))", suffix = "")
}
\arguments{
\item{pepinfo}{- list of peptides - sequence, optional modified sequence, charge state.}

\item{fasta}{- object as created by readPeptideFasta}

\item{prefix}{- default "(([RK])|(^)|(^M))"}

\item{suffix}{- default ""}
}
\description{
peptides which do not have protein assignment drop out
}
\examples{
library(prozor)
data(pepprot)

file = file.path(path.package("prozor"),"extdata/shortfasta.fasta" )

fasta = readPeptideFasta(file = file)
res = annotatePeptides(pepprot[1:20,], fasta)
head(res)
res = annotatePeptides(pepprot[1:20,"peptideSeq"],fasta)
length(res)
}
