% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeFasta.R
\name{writeFasta}
\alias{writeFasta}
\title{write fasta lists into file}
\usage{
writeFasta(file, ...)
}
\arguments{
\item{file}{where to write}

\item{...}{fasta list or single file}
}
\description{
peptides which do not have protein assignment drop out
}
\examples{
#example how to create a protein db with decoy sequences
library(seqinr)
library(prozor)
file = file.path(path.package("prozor"),"extdata/fgcz_contaminants_20150123.fasta")
fasta = readPeptideFasta(file = file)
revfasta <- reverseSeq(fasta)
decoyDB <- c(fasta,revfasta)
stopifnot(length(decoyDB) == 2 * length(fasta))
writeFasta(decoyDB, file="test.fasta")

}
