% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R, R/utils.R
\name{runSanityChecks}
\alias{runSanityChecks}
\alias{getDataDirectory}
\alias{getQueueFile}
\alias{getConfig}
\alias{getExclusionSet}
\title{Various Helper Functions}
\usage{
runSanityChecks()

getDataDirectory(package, date = format(Sys.Date()), path = ".",
  sep = "_")

getQueueFile(package, date = format(Sys.Date()), path = ".", sep = "_")

getConfig(debug = FALSE)

getExclusionSet(exclusionfile)
}
\arguments{
\item{package}{Character variable providing the package name.}

\item{date}{Optional character variable describing a date, default
is current date.}

\item{path}{Optional path, default is current directory.}

\item{sep}{Optional character with component separator, default is \dQuote{_}.}

\item{debug}{Optional boolean}

\item{exclusionfile}{Character variable with path and file for an optional
exclusion set.}
}
\value{
For \code{getDataDirectory}, a directory name. For \code{getQueueFile}, a queue
database file name (used only internally). For \code{getConfig}, a named vector with config
entries. For \code{getExclusionSet} a character vector of package names. Nothing is returned
by \code{runSanityChecks} which is invoked for its side effect of validation (currently only
if \code{run-xvfb-safe} is in the PATH).
}
\description{
These functions create a data directory name given a package name
and additional optional arguments which can be used to store test
meta-data and results, return a queue file name, return the
configuration object (retrieved from several standard locations)
and load the exclusion set.
}
\details{
Additional helper functions get particular directories, config settings or
check some assumptions about files in \code{PATH} and alike,
}
\section{Config File}{

An optional config file can be used to set several configuration variables.
Currently supported are
\describe{
  \item{setup}{The path to an R file that will be \code{source}'ed.}
  \item{workdir}{The directory used for the parallel run of reverse depends.}
  \item{libdir}{The directory passed to \code{.libPaths} allow for additonal
build-dependencies.}
  \item{debug}{A boolean switch to enable more debugging output.}
  \item{verbose}{A boolean switch to enable more verbose output.}
}
The \code{setup} field is particularly useful as the file being sourced
can contain other R expressions setting environment variables or options.
It is (currently) searched in the four locations \dQuote{.prrd.yaml},
\dQuote{~/.R/prrd.yaml}, \dQuote{~/.prrd.yaml},  and \dQuote{/etc/R/prrd.yaml}.
The first file found ends the search and is used, content is not merged from
several files.
}

\author{
Dirk Eddelbuettel
}
