% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trial.simulation.t2e.R
\name{trial.simulation.t2e}
\alias{trial.simulation.t2e}
\title{Simulating time-to-event data for current trial and external control}
\usage{
trial.simulation.t2e(
 n.CT, n.CC, nevent.C, n.ECp, nevent.ECp, accrual,
 out.mevent.CT, out.mevent.CC, driftHR,
 cov.C, cov.cor.C, cov.EC, cov.cor.EC, cov.effect,
 seed=sample.int(.Machine$integer.max,1))
}
\arguments{
\item{n.CT}{Number of patients in treatment group in the current trial.}

\item{n.CC}{Number of patients in concurrent control group in the current
trial.}

\item{nevent.C}{Number of events in treatment and concurrent control group
in the current trial.}

\item{n.ECp}{Number of patients in external control pool.}

\item{nevent.ECp}{Number of events in external control pool.}

\item{accrual}{Accrual rate, defined as the number of enrolled patients per
month.}

\item{out.mevent.CT}{True median time to event in treatment group in the
current trial.}

\item{out.mevent.CC}{True median time to event in concurrent control group
in the current trial.}

\item{driftHR}{Hazard ratio between concurrent and external control for
which the bias should be plotted.}

\item{cov.C}{List of covariate distributions for treatment and concurrent
control group in the current trial. Continuous and binary covariate are
applicable. The continuous covariate is assumed to follow a normal
distribution; for example, specified as
\code{list(dist="norm", mean=0, sd=1, lab="cov1")}. The binary covariate is
assumed to follow a binomial distribution; for example, specified as
\code{list(dist="binom", prob=0.4, lab="cov2")}. \code{lab} is the column
name of the covariate in the data frame generated.}

\item{cov.cor.C}{Matrix of correlation coefficients for each pair of
covariate for treatment and concurrent control group in the current trial,
specified as Gaussian copula parameter.}

\item{cov.EC}{List of covariate distributions for external control. The
continuous covariate is assumed to follow a normal distribution; for example,
specified as \code{list(dist="norm", mean=0, sd=1, lab="cov1")}. The binary
covariate is assumed to follow a binomial distribution; for example,
specified as \code{list(dist="binom", prob=0.4, lab="cov2")}. \code{lab} is
the column name of the covariate in the data frame generated, which must be
consistent with those used for \code{cov.C}.}

\item{cov.cor.EC}{Matrix of correlation coefficients for each pair of
covariate for external control, specified as Gaussian copula parameter.}

\item{cov.effect}{Vector of covariate effects on the outcome , specified as
hazard ratio per one unit increase in continuous covariates or as hazard
ratio between categories for binary covariates.}

\item{seed}{Setting a seed.}
}
\value{
The \code{trial.simulation.t2e} returns a data frame containing the
following variables:
\item{study}{Study indicator (0 for external control, and 1 for current
trial)}
\item{treat}{Treatment indicator (0 for concurrent and external control, and
1 for treatment)}
\item{time}{Time to event or censoring}
\item{status}{Censoring (0 for censored, and 1 for event occurred)}
\item{column name specified}{Covariate of interest}
}
\description{
A two-arm randomized clinical trial with a time-to-event outcome, which is
augmented by external control data, is simulated.
}
\details{
The time to event outcome is assumed to follow a Weibull
distribution. Given more than one covariates with their effects on the
outcome, a Weibull proportional hazards model is constructed for data
generation. The data frame generated include the time-to-event outcome data
and covariates for \code{n.CT} and \code{n.CC} patients in treatment and
concurrent control group in the current trial respectively, and \code{n.ECp}
patients in external control pool. One record per patient. More than one
covariates must be specified.
}
\examples{
n.CT       <- 100
n.CC       <- 50
nevent.C   <- 100
n.ECp      <- 1000
nevent.ECp <- 800
accrual    <- 16

out.mevent.CT <- 6
out.mevent.CC <- 6
driftHR       <- 1

cov.C <- list(list(dist="norm",mean=0,sd=1,lab="cov1"),
              list(dist="binom",prob=0.4,lab="cov2"))

cov.cor.C <- rbind(c(  1,0.1),
                   c(0.1,  1))

cov.EC <- list(list(dist="norm",mean=0,sd=1,lab="cov1"),
               list(dist="binom",prob=0.4,lab="cov2"))

cov.cor.EC <- rbind(c(  1,0.1),
                    c(0.1,  1))

cov.effect <- c(0.8,0.8)

trial.simulation.t2e(
   n.CT=n.CT, n.CC=n.CC, nevent.C=nevent.C,
   n.ECp=n.ECp, nevent.ECp=nevent.ECp, accrual=accrual,
   out.mevent.CT, out.mevent.CC, driftHR,
   cov.C=cov.C, cov.cor.C=cov.cor.C,
   cov.EC=cov.EC, cov.cor.EC=cov.cor.EC, cov.effect=cov.effect, seed=100)
}
