% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exampleData.R
\docType{data}
\name{exampleData}
\alias{exampleData}
\title{Simulated data set}
\format{
An object of class \code{list} of length 6.
}
\usage{
exampleData
}
\description{
Simulated data set for a quick test. The data set is a list with six
components: survival times \code{"t"}, event status \code{"di"}, covariates
\code{"x"}, number of genomics variables \code{"p"}, number of clinical
variables \code{"1"} and true effects of covariates \code{"beta_true"}.
The R code for generating the simulated data is given in the Examples
paragraph.
}
\examples{
# Load the example dataset
data("exampleData", package = "psbcSpeedUp")
str(exampleData)

# ===============
# The code below is to show how to generate the dataset "exampleData.rda"
# ===============

requireNamespace("MASS", quietly = TRUE)

########################### Predefined Functions

Expo <- function(times, surv) {
  z1 <- -log(surv[1])
  t1 <- times[1]
  lambda <- z1 / (t1)
  list(rate = lambda)
}

Weibull <- function(times, surv) {
  z1 <- -log(surv[1])
  z2 <- -log(surv[2])
  t1 <- times[1]
  t2 <- times[2]
  gamma <- log(z2 / z1) / log(t2 / t1)
  lambda <- z1 / (t1^gamma)
  list(scale = lambda, shape = gamma)
}

########################### Problem Dimensions
n <- 200
p <- 30
q <- 5
s <- 10

############################ Simulate a set of n x p covariates

# effects
bg <- c(0.75, -0.75, 0.5, -0.5, 0.25, -0.25, rep(0, p - 6))
bc <- c(-1.0, 1.0, 0.3, 0, -0.3)
bX <- c(bg, bc)

# covariates
# genomic
means <- rep(0, p)
Sigma <- diag(1, p)
Xg <- MASS::mvrnorm(n, means, Sigma)
# clinical
x1 <- rbinom(n = n, size = 1, prob = 0.7)
x2 <- rbinom(n = n, size = 1, prob = 0.3)
x3 <- rnorm(n = n, mean = 0, sd = 1)
x4 <- rnorm(n = n, mean = 0, sd = 1)
x5 <- rnorm(n = n, mean = 0, sd = 1)
Xc <- cbind(x1, x2, x3, x4, x5)
# all
X <- data.frame(Xg, Xc)
names(X) <- c(paste("G", 1:p, sep = ""), paste("C", 1:q, sep = ""))
X <- scale(X)

# censoring function
# - follow-up time 36 to 72 months
# - administrative censoring: uniform data entry (cens1)
# - loss to follow-up: exponential, 20\% loss in 72 months (cens2)
ACT <- 36
FUT <- 72
cens.start <- FUT
cens.end <- ACT + FUT
cens1 <- runif(n, cens.start, cens.end)
loss <- Expo(times = 72, surv = 0.8)
cens2 <- rexp(n, rate = loss$rate)
cens <- pmin(cens1, cens2)

# survival distribution (Weibull, survival probs 0.5 and 0.9 at 12 and 36 months)
h0 <- round(log(2) / 36, 2)
surv <- Weibull(times = c(12, 36), surv = c(0.9, 0.5))

dt <- (-log(runif(n)) * (1 / surv$scale) * exp(-as.matrix(X) \%*\% bX))^(1 / surv$shape)

# survival object
status <- ifelse(dt <= cens, 1, 0)
os <- pmin(dt, cens)

exampleData <- list("t" = os, "di" = status, "x" = X, "beta_true" = bX)

}
\keyword{datasets}
