% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{generate,DataSimObject-method}
\alias{generate,DataSimObject-method}
\title{Generate Data for a \code{DataSimObject}}
\usage{
\S4method{generate}{DataSimObject}(x, n = 1, treatment_hr = NULL, drift_hr = NULL)
}
\arguments{
\item{x}{a \code{DataSimObject} object created by \link{create_data_simulation}}

\item{n}{number of data sets to simulate}

\item{treatment_hr}{vector of numeric treatment effects}

\item{drift_hr}{vector of numeric drift effects}
}
\value{
A \link[=SimDataList-class]{SimDataList} object for use with \code{\link[=create_simulation_obj]{create_simulation_obj()}}.
}
\description{
Generate Data for a \code{DataSimObject}
}
\examples{
baseline_obj <- create_baseline_object(
  n_trt_int = 100,
  n_ctrl_int = 50,
  n_ctrl_ext = 10,
  covariates = baseline_covariates(
    names = c("age", "score"),
    means_int = c(55, 5),
    means_ext = c(60, 5),
    covariance_int = covariance_matrix(c(5, 1))
  )
)
sim_obj <- create_data_simulation(
  baseline_obj,
  coefficients = c(age = 0.001, score = 1.5),
  event_dist = create_event_dist(dist = "exponential", lambdas = 1 / 36)
)
data_sim_list <- generate(sim_obj, treatment_hr = c(0, 1), drift_hr = 0.5)
}
