% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_fpm.R
\name{surv_fpm}
\alias{surv_fpm}
\title{A function to obtain survival estimates from a flexible parametric model}
\usage{
surv_fpm(DC_clean, beta = 0, s = NULL)
}
\arguments{
\item{DC_clean}{a cleaned dataset ontained using dataComb().}

\item{beta}{a parameter to determine if the survival probabilities should be
adjusted by some (log) hazard ratio.  Defaults to beta=0, i.e. no adjustment.}

\item{s}{if specified will return the time at which some threshold is passed
(e.g. s=0.5 for median survival time)}
}
\value{
a list of times and assoicated survival probabilities
}
\description{
This function provides basic survival estimates from a flexible parametric survival
model
}
\details{
A fucntion which extracts survival probabilities from a flexsurvreg object
}
\examples{
library(psc)
library(survival)
data("surv.mod")
data("data")
dc <- dataComb(surv.mod,data)
s_est <- surv_fpm(dc)
}
