% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plr.R
\name{plr}
\alias{plr}
\title{Polygonal linear regression}
\usage{
plr(formula, data, model = TRUE, ...)
}
\arguments{
\item{formula}{an object of class "formula": a symbolic description of the model to be fitted.}

\item{data}{a environment that contains the variables of the study.}

\item{model}{logicals. If TRUE the corresponding components of the fit are returned.}

\item{...}{additional arguments to be passed to the low level polygonal linear regression fitting functions.}
}
\value{
residuals is calculated as the response variable minus the fitted values.

rank the numeric rank of the fitted polygonal linear model.

call the matched call.

fitted.values the fitted mean values.

terms the \code{\link[stats]{terms}}.

coefficients a named vector of coefficients.

model the matrix model for center and radius.
}
\description{
plr is used to fit polygonal linear models.
}
\examples{
yp <- psim(10, 10) #simulate 10 polygons of 10 sides
xp1 <- psim(10, 10) #simulate 10 polygons of 10 sides
xp2 <- psim(10, 10) #simulate 10 polygons of 10 sides
e <- new.env()
e$yp <- yp
e$xp1 <- xp1
e$xp2 <- xp2
fit <- plr(yp~xp1+xp2, e)
}
\references{
Silva, W.J.F, Souza, R.M.C.R, Cysneiros, F.J.A. (2019) \url{https://www.sciencedirect.com/science/article/pii/S0950705118304052}.
}
