% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_plot_npsdr.R
\name{plot.npsdr}
\alias{plot.npsdr}
\title{Scatter plot with sufficient predictors from npsdr() function}
\usage{
\method{plot}{npsdr}(x, ..., d = 1, lowess = TRUE)
}
\arguments{
\item{x}{object from the function \code{npsdr()}}

\item{...}{Additional arguments to be passed to generic \code{plot} function.}

\item{d}{number of sufficient predictors. Default is 1.}

\item{lowess}{draw a lowess curve. Default is TRUE.}
}
\value{
A scatter plot with sufficient predictors.
}
\description{
Scatter plot with sufficient predictors from npsdr() function
}
\examples{
\donttest{
set.seed(1)
n <- 200;
p <- 5;
x <- matrix(rnorm(n*p, 0, 2), n, p)
y <-  x[,1]/(0.5 + (x[,2] + 1)^2) + 0.2*rnorm(n)
obj_kernel <- npsdr(x, y, plot=FALSE)
plot(obj_kernel)
}
}
\seealso{
\code{\link{npsdr_x}}, \code{\link{npsdr}}
}
\author{
Jungmin Shin, \email{jungminshin@korea.ac.kr}, Seung Jun Shin, \email{sjshin@korea.ac.kr}, Andreas Artemiou \email{artemiou@uol.ac.cy}
}
