% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode_item.R
\name{recode_item}
\alias{recode_item}
\title{Recode values of a data frame}
\usage{
recode_item(data, cols, code_from = NULL, code_to = NULL, retain_code = NULL)
}
\arguments{
\item{data}{A data.frame or a data.frame extension (e.g. a tibble).}

\item{cols}{Columns that need to be recoded. See `dplyr::dplyr_tidy_select` for available options.}

\item{code_from}{vector. the order must match with vector for `code_to`}

\item{code_to}{vector. the order must match with vector for `code_from`}

\item{retain_code}{vector. Specify the values to be retain}
}
\value{
An object of the same type as .data. The output has the following properties:
1. Columns except the recoded columns from .data will be preserved
2. Recoded columns
}
\description{
Recode values of a data frame
}
\examples{
pre_recoded_df = tibble::tibble(x1 = 1:5, x2 = 5:1)
recoded_df = recode_item(pre_recoded_df, cols = dplyr::contains('x'),
                        code_from = 1:5,
                        code_to = 5:1)

}
