% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/three_way_interaction_plot.R
\name{three_way_interaction_plot}
\alias{three_way_interaction_plot}
\title{Three-way Interaction Plot}
\usage{
three_way_interaction_plot(
  model,
  data = NULL,
  cateogrical_var = NULL,
  graph_label_name = NULL,
  y_lim = NULL,
  plot_color = FALSE
)
}
\arguments{
\item{model}{object from \code{lme}, \code{lme4}, \code{lmerTest} object.}

\item{data}{data frame. If the function is unable to extract data frame from the object, then you may need to pass it directly}

\item{cateogrical_var}{list. Specify the upper bound and lower bound directly instead of using ± 1 SD from the mean. Passed in the form of \code{list(var_name1 = c(upper_bound1, lower_bound1),var_name2 = c(upper_bound2, lower_bound2))}}

\item{graph_label_name}{vector of length 4 or a switch function (see ?two_way_interaction_plot example). Vector should be passed in the form of c(response_var, predict_var1, predict_var2, predict_var3).}

\item{y_lim}{the plot's upper and lower limit for the y-axis. Length of 2. Example: \code{c(lower_limit, upper_limit)}}

\item{plot_color}{default if \code{FALSE}. Set to \code{TRUE} if you want to plot in color}
}
\value{
a \code{ggplot} object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} \cr
The function creates a two-way interaction plot. It will creates a plot with ± 1 SD from the mean of the independent variable. See below for supported model. I recommend using concurrently with \code{lm_model()}, \code{lme_model()}.
}
\details{
It appears that ``predict` cannot handle categorical factors. All variables are converted to numeric before plotting.
}
\examples{
lm_fit <- lm(Sepal.Length ~ Sepal.Width + Petal.Length + Petal.Width +
  Sepal.Width:Petal.Length:Petal.Width, data = iris)

three_way_interaction_plot(lm_fit, data = iris)

}
