% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_slope.R
\name{simple_slope}
\alias{simple_slope}
\title{Slope Estimate at Varying Level of Moderators}
\usage{
simple_slope(model, data = NULL)
}
\arguments{
\item{model}{model object from \code{lm}, \code{lme},\code{lmer}}

\item{data}{\code{data.frame}}
}
\value{
a list with the slope estimate data frame and a Johnson-Newman plot.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} \cr
The function uses the \code{interaction::sim_slopes()} to calculate the slope estimate at varying level of moderators (+/- 1 SD and mean).
Additionally, it will produce a Johnson-Newman plot that shows when the slope estimate is not significant
}
\examples{
fit <- lm_model(
  data = iris,
  response_variable = Sepal.Length,
  predictor_variable = tidyselect::everything(),
  three_way_interaction_factor = c(Sepal.Width, Petal.Width, Petal.Length)
)

simple_slope_fit <- simple_slope(
  model = fit,
)
}
