\name{plot.psych}
\alias{plot.psych}
\alias{plot.poly}
\alias{plot.irt}




\title{Plotting functions for the psych package of class ``psych"}
\description{Combines several plotting functions into one for objects of class ``psych".  This can be used to plot the results of \code{\link{fa}}, \code{\link{irt.fa}}, \code{\link{VSS}}, \code{\link{ICLUST}}, \code{\link{omega}}, \code{\link{factor.pa}}, or \code{\link{principal}}. 
}
\usage{
\method{plot}{psych}(x,labels=NULL,...)
\method{plot}{irt}(x,xlab,ylab,main,D,type=c("ICC","IIC","test"),cut=.3,labels,keys=NULL,...)
\method{plot}{poly}(x,D,xlab,ylab,ylim,main,type=c("ICC","IIC","test"),cut=.3,labels,keys=NULL,...)
%plot.psych(x,labels=NULL,...)
%plot.irt(x,xlab,ylab,main,D,type=c("ICC","IIC","test"),cut=.3,labels,keys=NULL,...)
%plot.poly(x,D,xlab,ylab,ylim,main,type=c("ICC","IIC","test"),cut=.3,labels,keys=NULL,...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{The object to plot }
  \item{labels}{Variable labels}
  \item{xlab}{Label for the x axis  -- defaults to Latent Trait}
  \item{ylab}{Label for the y axis}
  \item{ylim}{Specify the limits for the y axis}
  \item{main}{Main title for graph}
  \item{type}{"ICC" plots items, "IIC" plots item information, "test" plots test information, defaults to IIC. }
  \item{D}{The discrimination parameter}
  \item{cut}{Only plot item responses with discrimiantion greater than cut}
  \item{keys}{Used in plotting irt results from irt.fa.}
  \item{...}{other calls to plot}
}
\details{Passes the appropriate values to plot.  For plotting the results of \code{\link{irt.fa}}, there are three options: type = "IIC" (default) will plot the item characteristic respone function.  type = "IIC" will plot the item information function, and type= "test" will plot the test information function.

These are calls to the generic plot function that are intercepted for objects of type "psych".  More precise plotting control is available in the separate plot functions.  plot may be used for psych objects returned from \code{\link{fa}}, \code{\link{irt.fa}}, \code{\link{ICLUST}}, \code{\link{omega}}, as well as  \code{\link{principal}} 

A "jiggle" parameter is available in the factor.plot function (called from plot.psych when the type is a factor or cluster.  If jiggle=TRUE, then the points are jittered slightly (controlled by amount) before plotting.  This option is useful when plotting items with identical factor loadings (e.g., when comparing hypothetical models).

Objects from \code{\link{irt.fa}} are plotted according to "type" (Item informations, item characteristics, or test information).  In addition, plots for selected items may be done if using the keys matrix.  Plots of irt information return three invisible objects, a summary of information for each item at  levels of the trait, the average area under the curve (the average information) for each item as well as where the item is most informative.

It is also possible to create irt like plots based upon just a scoring key and item difficulties, or from a factor analysis and item difficulties.  These are not true IRT type analyses, in that the parameters are not estimated from the data, but are rather indications of item location and discrimination for arbitrary sets of items.  To do this, find \code{\link{irt.stats.like}} and then plot the results.

}
\value{Graphic output for factor analysis, cluster analysis and item response analysis. 

 
}

\author{William Revelle }
\note{ More precise plotting control is available in the separate plot functions.

 
}
\seealso{ \code{\link{VSS.plot}} and \code{\link{factor.plot}}, \code{\link{cluster.plot}}, \code{\link{fa}}, \code{\link{irt.fa}}, \code{\link{VSS}}, \code{\link{ICLUST}}, \code{\link{omega}}, \code{\link{factor.pa}}, or \code{\link{principal}}   
}
\examples{
test.data <- Harman74.cor$cov
f4 <- fa(test.data,4)
plot(f4)

#not run
#data(bfi)
#e.irt <- irt.fa(bfi[11:15])  #just the extraversion items
#plot(e.irt)   #the information curves
#
#ic <- iclust(test.data,3)   #shows hierarchical structure 
#plot(ic)                    #plots loadings
#


}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ multivariate }

