% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychReportData.R
\name{normData}
\alias{normData}
\title{normData}
\usage{
normData(data, idvar, dvs)
}
\arguments{
\item{data}{A dataframe}

\item{idvar}{Column indicating the individual participants}

\item{dvs}{List of numeric data columns to normalise}
}
\value{
dataframe
}
\description{
Aggregate data returning the mean, standard deviation, and standard error
}
\examples{

# Example 1:
library(dplyr)
dat <- createDF(nVP = 50, nTrl = 50, design = list("Comp" = c("comp", "incomp")))
dat <- addDataDF(dat,
  RT = list(
    "Comp comp" = c(500, 80, 100),
    "Comp incomp" = c(550, 80, 140)
  ),
  Error = list(
    "Comp comp" = 5,
    "Comp incomp" = 10
  )
)
datAggVP <- dat \%>\%
  group_by(VP, Comp) \%>\%
  summarize(
    N = n(),
    RT = mean(RT[Error == 0]),
    ER = (sum(Error) / N) * 100
  )
datAggVP <- normData(datAggVP, "VP", c("RT", "ER"))
}
